<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\AdminController;

// Public routes
Route::get('/', [IndexController::class, 'index']);
Route::get('/home', [IndexController::class, 'index']);
     
// Admin login routes
Route::get('/login', [LoginController::class, 'login'])->name('login');
Route::post('/login', [LoginController::class, 'check'])->name('login.check');

// Admin logout route
Route::post('/logout', function () {
    Auth::guard('admin')->logout();
    request()->session()->invalidate();
    request()->session()->regenerateToken();
    return redirect('/login');
})->name('logout');

// Protected admin routes
Route::middleware(['admin.auth'])->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::get('/host_information', [AdminController::class, 'host_information'])->name('host_information');
    Route::get('/activities', [AdminController::class, 'activities'])->name('activities');
    Route::get('/bookings', [AdminController::class, 'bookings'])->name('bookings');
    Route::get('/account_info', [AdminController::class, 'account_info'])->name('account_info');
    Route::get('/marketing', [AdminController::class, 'marketing'])->name('marketing');
    Route::get('/settings', [AdminController::class, 'settings'])->name('settings');
});





