<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="utf-8">
   
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">
    <meta name="csrf-token" content="{{ csrf_token() }}">
<!-- Google tag (gtag.js) -->
<!-- <script async src="https://www.googletagmanager.com/gtag/js?id=G-NMECRLL5QB"></script> -->
<!-- <script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-NMECRLL5QB');
</script> -->
    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

  <!-- Google fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Jost:wght@400;500;600&display=swap" rel="stylesheet">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="{{ asset('css/vendors.css') }}">
  <link rel="stylesheet" href="{{ asset('css/main.css') }}">
	<link rel="shortcut icon" type="image/x-icon" href="{{ asset('img/favicon.png') }}" />
    <title> @yield('title') | {{ config('app.name', 'Holiday Homes & Apartment Rentals - Visitors dubai') }} </title>

</head>

<body>
  <div class="preloader js-preloader">


    <div class="preloader__wrap">
      <div class="preloader__icon">
        <svg width="38" height="37" viewBox="0 0 38 37" fill="none" xmlns="http://www.w3.org/2000/svg">
          <g clip-path="url(#clip0_1_41)">
            <path d="M32.9675 13.9422C32.9675 6.25436 26.7129 0 19.0251 0C11.3372 0 5.08289 6.25436 5.08289 13.9422C5.08289 17.1322 7.32025 21.6568 11.7327 27.3906C13.0538 29.1071 14.3656 30.6662 15.4621 31.9166V35.8212C15.4621 36.4279 15.9539 36.92 16.561 36.92H21.4895C22.0965 36.92 22.5883 36.4279 22.5883 35.8212V31.9166C23.6849 30.6662 24.9966 29.1071 26.3177 27.3906C30.7302 21.6568 32.9675 17.1322 32.9675 13.9422V13.9422ZM30.7699 13.9422C30.7699 16.9956 27.9286 21.6204 24.8175 25.7245H23.4375C25.1039 20.7174 25.9484 16.7575 25.9484 13.9422C25.9484 10.3587 25.3079 6.97207 24.1445 4.40684C23.9229 3.91841 23.6857 3.46886 23.4347 3.05761C27.732 4.80457 30.7699 9.02494 30.7699 13.9422ZM20.3906 34.7224H17.6598V32.5991H20.3906V34.7224ZM21.0007 30.4014H17.0587C16.4167 29.6679 15.7024 28.8305 14.9602 27.9224H16.1398C16.1429 27.9224 16.146 27.9227 16.1489 27.9227C16.152 27.9227 23.0902 27.9224 23.0902 27.9224C22.3725 28.8049 21.6658 29.6398 21.0007 30.4014ZM19.0251 2.19765C20.1084 2.19765 21.2447 3.33365 22.1429 5.3144C23.1798 7.60078 23.7508 10.6649 23.7508 13.9422C23.7508 16.6099 22.8415 20.6748 21.1185 25.7245H16.9322C15.2086 20.6743 14.2994 16.6108 14.2994 13.9422C14.2994 10.6649 14.8706 7.60078 15.9075 5.3144C16.8057 3.33365 17.942 2.19765 19.0251 2.19765V2.19765ZM7.28053 13.9422C7.28053 9.02494 10.3184 4.80457 14.6157 3.05761C14.3647 3.46886 14.1273 3.91841 13.9059 4.40684C12.7425 6.97207 12.102 10.3587 12.102 13.9422C12.102 16.7584 12.9462 20.7176 14.6126 25.7245H13.2259C9.33565 20.6126 7.28053 16.5429 7.28053 13.9422Z" fill="#3554D1" />
          </g>

          <defs>
            <clipPath id="clip0_1_41">
              <rect width="36.92" height="36.92" fill="white" transform="translate(0.540039)" />
            </clipPath>
          </defs>
        </svg>
      </div>
    </div>

    <div class="preloader__title">Visitors dubai</div>
  </div>

  <main>


    <header data-add-bg="bg-white" class="header  js-header" data-x="header" data-x-toggle="is-menu-opened">
      <div data-anim="fade" class="header__container container-fluid">
        <div class="row justify-between items-center">

          <div class="col-auto">
            <div class="d-flex items-center">
         

              <a href="{{ url('/') }}" class="header-logo mr-30" data-x="header-logo" data-x-toggle="is-logo-dark">
                <img src="{{ asset('img/logo.png') }}" alt="logo icon">
                <img src="{{ asset('img/logo.png') }}" alt="logo icon">
              </a>

              <div class="relative xl:d-none">
                <div class="searchMenu-loc js-form-dd js-liverSearch">
                  <div class="d-flex items-center" data-x-dd-click="searchMenu-loc">
                    <i class="text-20 icon-search text-color-dark-1 mr-15"></i>

                    <div class="text-15 text-color-dark-1 ls-2 lh-16">
                      <input autocomplete="off" type="search" placeholder="Activities" class="text-color-dark-1 js-search js-dd-focus" />
                    </div>
                  </div>

                  <div class="searchMenu-loc__field shadow-2 js-popup-window" data-x-dd="searchMenu-loc" data-x-dd-toggle="-is-active">
                    <div class="bg-white px-30 py-30 sm:px-0 sm:py-15 rounded-4">
                      <div class="y-gap-5 js-results">

              
                        <div>
                          <button class="-link d-block col-12 text-left rounded-4 px-20 py-10 js-search-option">
                            <div class="d-flex items-center">
                              <div class="icon text-light-1 text-20">
                                <img src="{{ asset('img/cat1.png') }}" alt="Categories icon">
                              </div>
                              <div class="ml-10">
                                <div class="text-15 lh-12 fw-500 js-search-option-target">Desert Safari</div>
                             
                              </div>
                            </div>
                          </button>
                        </div>

                        <div>
                          <button class="-link d-block col-12 text-left rounded-4 px-20 py-10 js-search-option">
                            <div class="d-flex items-center">
                              <div class="icon text-light-1 text-20">
                                <img src="{{ asset('img/cat2.png') }}" alt="Categories icon">
                              </div>
                              <div class="ml-10">
                                <div class="text-15 lh-12 fw-500 js-search-option-target">City Tour</div>
                             
                              </div>
                            </div>
                          </button>
                        </div>

                      <div>
                          <button class="-link d-block col-12 text-left rounded-4 px-20 py-10 js-search-option">
                            <div class="d-flex items-center">
                              <div class="icon text-light-1 text-20">
                                <img src="{{ asset('img/cat3.png') }}" alt="Categories icon">
                              </div>
                              <div class="ml-10">
                                <div class="text-15 lh-12 fw-500 js-search-option-target">Dhow Cruise</div>
                             
                              </div>
                            </div>
                          </button>
                        </div>

                        <div>
                          <button class="-link d-block col-12 text-left rounded-4 px-20 py-10 js-search-option">
                            <div class="d-flex items-center">
                              <div class="icon text-light-1 text-20">
                                <img src="{{ asset('img/cat4.png') }}" alt="Categories icon">
                              </div>
                              <div class="ml-10">
                                <div class="text-15 lh-12 fw-500 js-search-option-target">Attractions</div>
                             
                              </div>
                            </div>
                          </button>
                        </div>
                        <div>
                          <button class="-link d-block col-12 text-left rounded-4 px-20 py-10 js-search-option">
                            <div class="d-flex items-center">
                              <div class="icon text-light-1 text-20">
                                <img src="{{ asset('img/cat5.png') }}" alt="Categories icon">
                              </div>
                              <div class="ml-10">
                                <div class="text-15 lh-12 fw-500 js-search-option-target">Adventure</div>
                             
                              </div>
                            </div>
                          </button>
                        </div>


                      </div>
                    </div>
                  </div>
                </div>
              </div>


            

            </div>
          </div>


          <div class="col-auto">

            
            <div class="d-flex items-center">

              <a href="https://zapiodubai.com/SK/visitors-dubai-new/pro/" class="d-flex items-center text-15 text-black">
                <span class="js-currencyMenu-mainTitle">PLUS for Business</span>
              </a>


              <div class="d-flex items-center ml-20 is-menu-opened-hide md:d-none">
                
                <div class="dropdown js-dropdown js-services-active">
                  <button class="dropdown__button d-flex items-center justify-between  rounded-4  text-14 px-20 text-14 bg-white  text-blue-1" data-el-toggle=".js-services-toggle" data-el-toggle-active=".js-services-active">
                    <i class="icon icon-menu-2 text-20 ml-10"></i>
                    <i class="icon icon-user text-20 ml-10"></i>
                  </button>

                  <div class="toggle-element -dropdown  js-click-dropdown js-services-toggle">
                    
                    <div class="text-14 y-gap-15 js-dropdown-list">

                      <div><a href="#" class="d-block js-dropdown-link">Cart</a></div>

                      <div><a href="#" class="d-block js-dropdown-link">
                        Log In / Sign Up
                        </a></div>

                      <div><a href="#" class="d-block js-dropdown-link">
                        Recently Viewed
                      </a></div>

                  
                    </div>
                  </div>
                </div>


                

              </div>
              
              <div class="d-none xl:d-flex x-gap-20 items-center pl-30 text-white" data-x="header-mobile-icons" data-x-toggle="text-white">
                <div><a href="login.html" class="d-flex items-center icon-user text-inherit text-22"></a></div>
                <div><a href="login.html" class="d-flex items-center icon-user text-inherit text-22"></a></div>
              </div>

            </div>
          </div>

        </div>

        

      </div>
      <section class="bg-white sknh">

      <div class=" container-fluid">

      <div class="row">
        <div class="col-12">


          <div class="row justify-between items-center">

            <div class="col-auto">
            <div class="tabs -bookmark-2 js-tabs">
            <div class="tabs__controls d-flex items-center  js-tabs-controls">





              
              <div  class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button js-anchor-link" href="#sec1">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat1.png') }}" alt="Categories icon">

                  </i>
                  Desert Safari
                </a>



                
              </div>






              <div class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button js-anchor-link" href="#sec2">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat2.png') }}" alt="Categories icon">

                  </i>
                  City Tour
                </a>
              </div>

              <div class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button js-anchor-link" href="#sec3">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat3.png') }}" alt="Categories icon">

                  </i>
                  Dhow Cruise
                </a>
              </div>

              <div class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button js-anchor-link" href="#sec4">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat4.png') }}" alt="Categories icon">

                  </i>
                  Attractions
                </a>
              </div>

              <div class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button js-anchor-link" href="#sec5">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat5.png') }}" alt="Categories icon">

                  </i>
                  Adventure
                </a>
              </div>
              <div class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button js-anchor-link" href="#sec5">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat10.png') }}" alt="Categories icon">

                  </i>
                  Scuba Diving
                </a>
              </div>
              <div class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button js-anchor-link" href="#sec6">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat6.png') }}" alt="Categories icon">

                  </i>
                  Big Bus
                </a>
              </div>

              <div class="">
                <a class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button " href="#sec4">
                  <i class="icon-sk text-20 mr-10 sm:mr-5">
                    <img src="{{ asset('img/cat7.png') }}" alt="Categories icon">

                  </i>
                  Hot Air Balloon

                </a>    
              </div>

              <div class="">
                <button class="tabs__button px-20 py-10 sm:px-20 sm:py-15 rounded-4 fw-600 text-white js-tabs-button " data-x-click="lang">
              
                  More
                  <i class="icon icon-arrow-right text-20 ml-10 sm:ml-5"></i>
                </button>
              </div>
         










            </div>

           
          </div>
        </div>

        <div class="col-auto">
          <div class="row x-gap-10 y-gap-10 items-center">

         

            <div class="col-auto">
             
              <a href="#" class="button -blue-1 h-40 px-20 rounded-100 bg-blue-1-05 text-15 text-blue-1">
                Most Recent <div class="icon-location-pin ml-15"></div>
              </a>
            </div>

            <div class="col-auto">
          


              <a href="#" class="button -blue-1 h-40 px-20 rounded-100 bg-blue-1-05 text-15 text-blue-1">
                Filter <div class="icon-up-down ml-15"></div>
              </a>
            </div>

          </div>

        </div>




        </div>
          
        </div>







      </div>
    </div>
      </section>



    </header>



    @if(session('toast'))
<script>
    window.addEventListener('DOMContentLoaded', () => {
        const toastEl = document.getElementById('liveToast');
        toastEl.querySelector('#toastMessage').textContent = @json(session('toast.message'));
        toastEl.classList.remove('bg-success','bg-danger','bg-warning'); // clean slate
        toastEl.classList.add('bg-' + @json(session('toast.type')));
        const toast = new bootstrap.Toast(toastEl);
        toast.show();
    });
</script>
@endif
@yield('content')






<footer class="footer -type-1 text-white bg-dark-2">
      <div class="container-fluid">
        <div class="pt-60 pb-60">
          <div class="row y-gap-40 justify-between xl:justify-start">
            <div class="col-xl-2 col-lg-4 col-sm-6">
              <h5 class="text-16 fw-500 mb-30">Contact Us</h5>

              <div class="mt-30">
                <div class="text-14 mt-30">Toll Free Customer Care</div>
                <a href="#" class="text-18 fw-500 mt-5">+(1) 123 456 7890</a>
              </div>

              <div class="mt-35">
                <div class="text-14 mt-30">Need live support?</div>
                <a href="#" class="text-18 fw-500 mt-5">info@visitorsdubai.com</a>
              </div>
            </div>

            <div class="col-xl-2 col-lg-4 col-sm-6">
              <h5 class="text-16 fw-500 mb-30">Company</h5>
              <div class="d-flex y-gap-10 flex-column">
                <a href="#">About Us</a>
                <a href="#">Careers</a>
                <a href="#">Blog</a>
                <a href="#">Press</a>
               
              </div>
            </div>

            <div class="col-xl-2 col-lg-4 col-sm-6">
              <h5 class="text-16 fw-500 mb-30">Support</h5>
              <div class="d-flex y-gap-10 flex-column">
                <a href="#">Contact</a>
                <a href="#">Legal Notice</a>
                <a href="#">Privacy Policy</a>
                <a href="#">Terms and Conditions</a>
              
              </div>
            </div>

            <div class="col-xl-2 col-lg-4 col-sm-6">
              <h5 class="text-16 fw-500 mb-30">Other Services</h5>
              <div class="d-flex y-gap-10 flex-column">
           
                <a href="#">Tour List</a>
          
                <a href="#">Cruise Ticket</a>
                <a href="#">Holiday Rental</a>
                <a href="#">Travel Agents</a>
              </div>
            </div>

            <div class="col-xl-2 col-lg-4 col-sm-6">
              <h5 class="text-16 fw-500 mb-30">Mobile</h5>

              <div class="d-flex items-center px-20 py-10 rounded-4 border-white-15">
                <div class="icon-apple text-24"></div>
                <div class="ml-20">
                  <div class="text-14 text-white">Download on the</div>
                  <div class="text-15 lh-1 fw-500">Apple Store</div>
                </div>
              </div>

              <div class="d-flex items-center px-20 py-10 rounded-4 border-white-15 mt-20">
                <div class="icon-play-market text-24"></div>
                <div class="ml-20">
                  <div class="text-14 text-white">Get in on</div>
                  <div class="text-15 lh-1 fw-500">Google Play</div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="py-20 border-top-white-15">
          <div class="row justify-between items-center y-gap-10">
            <div class="col-auto">
              <div class="row x-gap-30 y-gap-10">
                <div class="col-auto">
                  <div class="d-flex items-center">
                    © 2022 visitorsdubai All rights reserved.
                  </div>
                </div>

                <div class="col-auto">
                  <div class="d-flex x-gap-15">
                    <a href="#">Privacy</a>
                    <a href="#">Terms</a>
                    <a href="#">Site Map</a>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-auto">
              <div class="row y-gap-10 items-center">
                <div class="col-auto">
                  <div class="d-flex items-center">
                    <button class="d-flex items-center text-14 fw-500 text-white mr-10">
                      <i class="icon-globe text-16 mr-10"></i>
                      <span class="underline">English (US)</span>
                    </button>

                    <button class="d-flex items-center text-14 fw-500 text-white">
                      <i class="icon-usd text-16 mr-10"></i>
                      <span class="underline">USD</span>
                    </button>
                  </div>
                </div>

                <div class="col-auto">
                  <div class="d-flex x-gap-20 items-center">
                    <a href="#"><i class="icon-facebook text-14"></i></a>
                    <a href="#"><i class="icon-twitter text-14"></i></a>
                    <a href="#"><i class="icon-instagram text-14"></i></a>
                    <a href="#"><i class="icon-linkedin text-14"></i></a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>

  </main>

  <div class="langMenu is-hidden js-langMenu" data-x="lang" data-x-toggle="is-hidden">
    <div class="langMenu__bg" data-x-click="lang"></div>

    <div class="langMenu__content bg-white rounded-4">
      <div class="d-flex items-center justify-between px-30 py-20 sm:px-15 border-bottom-light">
        <div class="text-20 fw-500 lh-15">Select your Categories</div>
        <button class="pointer" data-x-click="lang">
          <i class="icon-close"></i>
        </button>
      </div>

      <div class="modalGrid px-30 py-30 sm:px-15 sm:py-15">

        <div class="modalGrid__item js-item">
        
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat1.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Desert Safari</h4>
     
          </div>



        </div>

        <div class="modalGrid__item js-item">
        
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat2.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">City Tour</h4>
     
          </div>


        </div>

        <div class="modalGrid__item js-item">
   

          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat3.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Dhow Cruise</h4>
     
          </div>

        </div>

        <div class="modalGrid__item js-item">
      
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat4.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Attractions</h4>
     
          </div>


        </div>

        <div class="modalGrid__item js-item">
         
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat5.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Adventure</h4>
     
          </div>


        </div>

        <div class="modalGrid__item js-item">
          
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat6.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Big Bus</h4>
     
          </div>


        </div>

        <div class="modalGrid__item js-item">
        
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat7.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Hot Air Balloon</h4>
     
          </div>



        </div>

        <div class="modalGrid__item js-item">
        
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat8.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Helicopter Tour</h4>
     
          </div>


        </div>

        <div class="modalGrid__item js-item">
        

          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat9.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Seaplane Tours</h4>
     
          </div>

        </div>

        <div class="modalGrid__item js-item">
         

          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat10.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Scuba Diving</h4>
     
          </div>
        </div>

        <div class="modalGrid__item js-item">
      
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat11.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Sky Diving</h4>
     
          </div>

        </div>

        <div class="modalGrid__item js-item">
      

          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat12.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Yellow Boats</h4>
     
          </div>
        </div>

        <div class="modalGrid__item js-item">
       
          
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat13.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Jet Ski</h4>
     
          </div>
        </div>

        <div class="modalGrid__item js-item">
    
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat14.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Water Park</h4>
     
          </div>


        </div>

        <div class="modalGrid__item js-item">
       

          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat15.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Yacht Rental</h4>
     
          </div>
        </div>

        <div class="modalGrid__item js-item">
       
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat16.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Theme Park</h4>
     
          </div>


        </div>

        <div class="modalGrid__item js-item">
       
          <div class="tourTypeCard__content text-center pt-10 pb-10 px-10">
            <i class="text-10 sm:text-10 text-blue-1"><img src="{{ asset('img/cat17.png') }}" alt="Categories icon"></i>
            <h4 class="text-dark-1 text-18 fw-300 mt-10 md:mt-10">Musandam Tour</h4>
     
          </div>

        </div>

     

     

       

      </div>
    </div>
  </div>




 

  <!-- JavaScript -->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAAz77U5XQuEME6TpftaMdX0bBelQxXRlM"></script>
  <script src="https://unpkg.com/@googlemaps/markerclusterer/dist/index.min.js"></script>

  <script src="js/vendors.js"></script>
  <script src="js/main.js"></script>
  
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <script>
    $(document).ready(function () {
      $('.js-anchor-link').click(function(e) {
        e.preventDefault();
        var target = $($(this).attr('href'));
        if (target.length) {
          var scrollTo = target.offset().top - 150;
          $('html, body').animate({
            scrollTop: scrollTo
          }, 100);
        }
      });
    });
  </script>


</body>

</html>




